.if ~?def(DEF_TAO_EQUS)
DEF_TAO_EQUS=TRUE

******************
** TAO_EQUS.INC **
******************

*option flags

OPT_IGN=-33
OPT_SET=-32

*prefs structure

	structure
	int32	CUI_BORDERSIZE
	int32	CUI_BUTTONSIZE
	int32	CUI_WPRIMARY
	int32	CUI_WMOUSE
	int32	CUI_WKEYBOARD
	int32	CUI_WSECONDARY
	size	CUI_SIZE

	dbitstart
	dbit	GA_BORDER,BGA_BORDER
	dbit	GA_TITLE,BGA_TITLE
	dbit	GA_CLOSE,BGA_CLOSE
	dbit	GA_MINIMIZE,BGA_MINIMIZE
	dbit	GA_MAXIMIZE,BGA_MAXIMIZE

*mouse variables structure

	structure
	pointer	MS_SAVE	;mouse background save
	int32	MS_CLICKSTATE	;click state
	int32	MS_CLICKSTART	;click start time
	pointer	MS_CONTROLPNT	;mouse variables pointer
	int32	MS_FLAG	;mouse on/off state flag
	int32	MS_MODE	;mouse mode value
	int32	MS_OLDX	;old mouse x value
	int32	MS_OLDY	;old mouse y value
	int64	MS_ID	;mouse device id
	int32	MS_CURRENTX
	int32	MS_CURRENTY
	size	MS_VARSIZE

*mouse button bits

	dbitstart
	dbit	MB_LEFT,BMB_LEFT
	dbit	MB_RIGHT,BMB_RIGHT
	dbit	MB_DRAG,BMB_DRAG
	dbit	MB_DOUBLE,BMB_DOUBLE

*GUI screen variables structure

	structure	;screen vars
	int32	SC_TILE	;pointer to backdrop tile data
	int32	SC_TWIDTH	;tile width
	int32	SC_THEIGHT	;tile height
	int32	SC_TCLUT	;backrop tile clut pointer
	int32	SC_TCPEN	;start clut pen
	int32	SC_TCPENS	;number of clut pens
	int32	SC_SIZE	;size

*Chip number equates

	structure
	byte	P_VP
	byte	P_T800
	byte	P_T400
	byte	P_I386
	byte	P_I386F
	byte	P_ARM2
	byte	P_ARM2F
	byte	P_TIC40
	byte	P_ARM6
	byte	P_ARM6F
	byte	P_T9000
	byte	P_R3000
	byte	P_R3000F
	byte	P_ALPHA
	byte	P_I486
	byte	P_PENTIUM
	byte	P_PPC601B
	byte	P_PPC601
	byte	P_PPC602
	byte	P_PPC603
	byte	P_PPC604
	byte	P_SH1
	byte	P_SH2
	byte	P_SH3
	byte	P_R4000
	byte	P_MC68000

;Auto nestting var
__str_base:=0	;initial value

;Tool num for string que
__tool_num:=0	;initial value

;Psuedo op macros

__alipnt:=-1	;value for align pointer

.imacro	even 	;align with suppresion of multiple aligns
 .if __alipnt<>$
	align
__alipnt:=$
 .endif
.endm

.imacro	string	;name,string
	;define string
	.check %N=2	;args
%1:	dc	%2,0
.endm

;Useful equates

NULL=0
MINT=$80000000
MAXINT=$7fffffff

*Standard Object and Message types

	dbitstart	;object types
	dbit	TOOLTP,BTOOLTP	;tool type
	dbit	CONTROLTP,BCONTROLTP	;control
	dbit	BITMAPTP,BBITMAPTP	;window
	dbit	GOBTP,BGOBTP		;graphic

CLASSTP=TOOLTP	;a CLASSTP is a subclass of TOOLTP
BCLASSTP=BTOOLTP	;a CLASSTP is a subclass of TOOLTP

	dbitstart	;message types
	dbit	SYSTEMTP,BSYSTEMTP	;system type
	dbit	ENQUIRETP,BENQUIRETP	;enquire type
	dbit	CHILDTP,BCHILDTP	;child type
	dbit	DEVICETP,BDEVICETP	;device type
	dbit	ARRAYTP,BARRAYTP	;array type
	dbit	FUNCTP,BFUNCTP	;function type
	dbit	DATATP,BDATATP	;data type
	dbit	STREAMTP,BSTREAMTP	;input type
	dbit	RESIZETP,BRESIZETP	;resize type
	dbit	REFRESHTP,BREFRESHTP	;gui update type
	dbit	MOUSETP,BMOUSETP	;mouse type
	dbit	KEYBOARDTP,BKEYBOARDTP	;cooked keyboard type
	dbit	FLOWTP,BFLOWTP	;flow type
	dbit	GROUPTP,BGROUPTP	;group type
	dbit	RAWKEYTP,BRAWKEYTP	;raw keyboard type

*Common data structures and macros

;List header structure

	structure
	pointer	LH_HEAD	;pointer to first
	pointer	LH_TAIL	;always 0
	pointer	LH_TAILPRED	;pointer to last
	size	LH_SIZE	;size

.imacro	listheader	;listname
	;list template
 .check	%N=1
	even
%1:	dc.i	%1+LH_TAIL	;list head points to list tail
	dc.i	0	;list tail is zero
	dc.i	%1+LH_HEAD	;list tailpred points to list head
.endm

;List node structure

	structure
	pointer	LN_SUCC	;pointer to successor
	pointer	LN_PRED	;pointer to predessesor
	size	LN_SIZE	;size

;Memory node structure

	structure
	struct	MN_NODE,LN_SIZE	;link node
	int32	MN_BYTES	;memory size
	size	MN_SIZE	;size

;Mailbox structure

	structure
	struct	MB_LIST,LH_SIZE	;mailbox list header
	int32	MB_MAGIC	;mailbox validation
	pointer	MB_STATE	;mailbox state (NULL or wptr)
	int32	MB_FILTER	;mailbox type filter guard
	size	MB_SIZE	;size

;Chained mailbox structure

	structure
	struct	CM_NODE,MN_SIZE	;mem node
	struct	CM_MAILBOX,MB_SIZE	;mailbox
	size	CM_SIZE	;size

;Message header structure

	structure
	struct	MG_NODE,LN_SIZE	;link node
	int32	MG_LENGTH	;total message size (in bytes)
	int32	MG_TYPE	;message type/s (bit significent)
	int32	MG_OFFSET	;data offset (in bytes)
	int32	MG_NDP	;next destination pointer (index)
	pointer	MG_DTM	;destination target mailbox ids

.imacro	msg	;name,type
	;message template
 .check	%N=2
	even
%1:	dc.i 	$87654321
	dc.i	NULL	;link node
	dc.i	%1e-%1	;message size into MN_BYTES
	dc.i	%2	;MG_TYPE
	dc.i	%1d-%1	;MG_OFFSET
	dc.i	1	;MG_NDP
.endm

.imacro	dtmend	;name
 .check	%N=1
	dc.i	NULL,NULL	;force null on end
%1d:
.endm

.imacro	msgend	;name
 .check	%N=1
%1e:
.endm

;Component header structure

	structure
	int32	CP_VEC	;vector to next extention
	pointer	CP_TOOL	;code pointer
	size	CP_SIZE	;size

;Component flags

	dbitstart	;component flags
	dbit	VIRTUAL,BVIRTUAL	;virtual tool flag
	dbit	FIXUP,BFIXUP		;fixup flag
	;FIXUP+VIRTUAL=after first access stay permanent
	;FIXUP alone=enable ENCAPULATION mode

;Standard node flag bits

	dbitstart
	dbit	TEMPLATE,BTEMPLATE	;set if template node
	dbit	DUMMY,BDUMMY	;set if dummy object
	dbit	NOFREE,BNOFREE	;set if no-auto free
	dbit	GUI,BGUI	;set if must run on gui
	dbit	STDIO,BSTDIO	;set if takes stdio protocol
	dbit	HI,BHI	;set if high priority
	dbit	CENTER,BCENTER	;set if object should center
	dbit	EMBED,BEMBED	;set if object may be encapsulated
	dbit	HERE,BHERE	;set if need to run 'here'

;Link flag bits

	dbitstart
	dbit	DOHINT,BDOHINT	;clear if hint needed
	dbit	DOREROUTE,BDOREROUTE	;clear if reroute needed
	dbit	DONEREAD,BDONEREAD	;private flag for inblk/outblk
	dbit	DONESEND,BDONESEND	;private flag for inblk/outblk

;Node nameing

.imacro	nodename	;prefix specifying name for next node
 .check %N=1	;must have param of node name
 .align
%Lb:	dc.i	$12345643
	dc.i	%Le-%Lb
	dc.b	%1
	dc.b	0
 .align
%Le:
.endm

;Node structure

	structure
	struct	ND_NODE,MN_SIZE	;memory node
	int32	ND_TYPE	;node type
	int32	ND_NUMBER	;node number
	int32	ND_FLAGS	;node flags
	int32	ND_REFS	;node reference count/tags count
	int32	ND_ISBN	;node ID number
	int64	ND_SERVER	;node default server mailbox ID
	int32	ND_NULL	;null at end
	size	ND_SIZE	;size

.imacro	node	;name,type,number,nflags
	;node template
	.check %N=4
__proc_type:=SAVETEXTQ __proc_type_q,0,%3
	even
%1:	dc.i	$12345678 ;signature
	dc.i	__time	;time of assembly
	dc.i	%1e-%1	;objects size into MN_BYTES
	dc.i	%2	;ND_TYPE (e.g. TOOLTP)
 .if %2=TOOLTP
	dc.i	P_%3	;ND_NUMBER (used for VP etc)
 .else
	dc.i	%3	;ND_NUMBER
 .endif
	dc.i	%4	;ND_FLAGS
	dc.i	__t_%1	;ND_REFS/tag count
	dc.i	NULL	;ND_ISBN
	dc.i	NULL,NULL	;ND_SERVER
	dc.i	NULL	;ND_NULL
	chkembed %4{1,99U}
.endm

.imacro	chkembed
__ndembed:=%1{#99}=%1{#'EMBED'}	;used to check embeding with QCL's !
.endm

.imacro	nodeend	;name
	;node end template
	.check %N=1
	even
 .debuginfo
%1e:
__t_%1=__tags
.endm

;Tool node header structure

.imacro	tool	;string,{string1}
	;tool header template
 .check	%N=1|2
__tlembed:=__ndembed
%La:	dc.i	%Lb-%La
	dc.i	NULL		;header control code
	dc	%1{1,99U},NULL	;string
 .if %N=2
	dc	%2{1,99},NULL	;string
 .endif
	even
	dc.i	%Lb-%La
%Lb:
 .zerotag		;restart VP tags for each new tool
	__qcall_q:=0		;restart QCALLs each new tool
	__string_q:=0		;and for printf/tracef strings
	__def_n:=0		;and for DEFCALL (incase duplicates)
 .eval __tool_num
	dc.i	(__cd%e_nd-__cd%e_st)+CP_SIZE
	dc.i	NULL	;component code
__cd%e_st:	.GETTEXTQ __proc_type_q,__proc_type
 .debugzero
	.%T
__cd%e_r4:
.endm

.imacro	toolend		;toolname
 .if 0<>GETNUMQ __string_q
 .rept GETNUMQ __string_q
 .eval (GETNUMQ __string_q)-%x
 .GETTEXTQ __string_q,%e
	.eval __tool_num+%e
__string_%e:
	nlstr	%T
 .endr
 .endif
	even
 .off
	align
 .eval __tool_num
	dc.i	(__cd%e_nd-__cd%e_st)+CP_SIZE
__cd%e_nd:	__tool_num:=__tool_num+1000
	;do components
 .if 0<>GETNUMQ __qcall_q
 .check __tlembed	;EMBED when using external tools !
 .rept GETNUMQ __qcall_q
 .eval (GETNUMQ __qcall_q)-%x
	dc.i	12
	dc.i	(__str_%1_%e-%1)|((GETFLAGQ __qcall_q,%e)&3)
	dc.i	12
 .endr
 .endif
	dc.i	0	;end components
	;now toolname strings
 .if 0<>GETNUMQ __qcall_q
 .rept GETNUMQ __qcall_q
 .eval (GETNUMQ __qcall_q)-%x
 .GETTEXTQ __qcall_q,%e
	even
__str_%1_%e:
	dc.i	NULL,NULL	;space for ID
	dc	'%T',0	;string itself
 .endr
 .endif
.endm

.imacro	defcall	;handle,unquoted-string[,flags]
	__def_n:=__def_n+4
 .if %N=2
	__tmp1:=SAVETEXTQ __qcall_q,0,%1{1,99U}
	__tmp2:=PUTTEXTQ __qcall_q,__tmp1,__def_n,%2{1,99U}
 .else
 .check %N=3 ;DEFCALL requires 2 or 3 params
	__tmp1:=SAVETEXTQ __qcall_q,(%3)&3,%1{1,99U}
	__tmp2:=PUTTEXTQ __qcall_q,__tmp1,0,%1{1,99U}
	__tmp2:=PUTTEXTQ __qcall_q,__tmp1,(%3)&3+__def_n,%2{1,99U}
 .endif
.endm

.imacro	nlstr	;Cstring
 .ifnb	%1{&'\n',1}
	dc	%1{1,'\n'}%1{1,1},10	;str+newline
	nlstr	%1{1,1}%1{'\n',99}	;do rest
 .else
	dc	%1,0	       ;string with no newline
 .endif
.endm

.imacro	compend
	;components end marker
	dc.i	NULL	;end of components marker
.endm

;Control node header structure

	structure
	struct	CT_NODE,ND_SIZE	;object node
	struct	CT_EXT,CP_SIZE	;component node
	struct	CT_MAILBOX,MB_SIZE	;control mailbox
	struct	CT_DECLARE,LH_SIZE	;control declare list
	pointer	CT_WKSTART	;workspace block pointer
	int32	CT_WKSIZE	;workspace block size
	pointer	CT_STSTART	;stack block pointer
	int32	CT_STSIZE	;stack block size
	int64	CT_PARENT	;parent mailbox id
	int32	CT_BITMAP	;bitmap pointer (0=none)
	int32	CT_STDIO	;stdio vars pointer (0=none)
	int32	CT_USER1
	int32	CT_USER2
	int32	CT_USER3
	int32	CT_USER4	;user space
	size	CT_SIZE	;4 before end of component

.imacro	control	;code,stack,filter,{size},{u1,u2,u3,u4,u5,u6,...}
	;control header template
 .check	%N>=4
%Lx3:
	dc.i	%Lx4-%Lx3
	dc.i	%1	;header control code
	dc.i	0,0,0	;MB_LIST,mailbox list header
	dc.i	NULL	;MB_MAGIC
	dc.i	NULL	;MB_STATE
	dc.i	%3	;MB_FILTER
	dc.i	0,0,0	;address list header
	dc.i	NULL	;CT_WKSTART
	dc.i	NULL	;CT_WKSIZE
	dc.i	NULL	;CT_STSTART
	dc.i	%2	;CT_STSIZE
	dc.i	NULL
	dc.i	NULL	;CT_PARENT mailbox id
	dc.i	NULL
	dc.i	NULL
 .if %N=4
	blk.b	%4,0
 .elseif %N>4
 .rept %N-3
	dc.i	%4	;CT_USER?
 .mshift
 .endr
 .endif
	dc.i	%Lx4-%Lx3
%Lx4:
.endm

;Bitmap node header structure

	structure
	struct	BM_NODE,ND_SIZE	;object node
	struct	BM_EXT,CP_SIZE	;component node
	pointer	BM_PARENT	;parent bitmap pointer (0=none)
	int32	BM_X	;x
	int32	BM_Y	;y
	int32	BM_Z	;z
	int32	BM_WIDTH	;bitmap width (pixels)
	int32	BM_HEIGHT	;bitmap height (pixels)
	int32	BM_DEPTH	;bitmap depth (pixels)
	int32	BM_CLIPX
	int32	BM_CLIPY
	int32	BM_CLIPZ
	int32	BM_CLIPX1
	int32	BM_CLIPY1
	int32	BM_CLIPZ1	;clip rectangle cords
	int32	BM_XOFFSET
	int32	BM_YOFFSET
	int32	BM_ZOFFSET	;bitmap offsets (pixels)
	int32	BM_CURSORX	;x cursor position
	int32	BM_CURSORY	;y cursor position
	int32	BM_CURSORZ	;z cursor position
	int32	BM_NEWX	;resize x
	int32	BM_NEWY	;resize y
	int32	BM_NEWZ	;resize z
	int32	BM_NEWWIDTH	;resize bitmap width (pixels)
	int32	BM_NEWHEIGHT	;resize bitmap height (pixels)
	int32	BM_NEWDEPTH	;resize depth (pixels)
	pointer	BM_BITMAP	;bitmap bitmap (0=global bitmap?)
	int32	BM_BITSIZE	;bitmap memory (0=?)
	struct	BM_HOTLIST,LH_SIZE	;hot patch list
	struct	BM_TRIGLIST,LH_SIZE	;trigger patch list
	int32	BM_INK	;ink colour
	int32	BM_PAPER	;paper colour
	struct	BM_TSTATE,16	;terminal status
	pointer	BM_FONT	;font for bitmap (default=vga8x8)
	pointer	BM_CLUT	;clut section for bitmap (0=default -1=ignore)
	int32	BM_CLUTPEN	;clut start pen number
	int32	BM_CLUTLEN	;clut section length
	int32	BM_CONTROL	;pointer to controling object (0=none)
	int32	BM_USER1
	int32	BM_USER2
	int32	BM_USER3
	int32	BM_USER4	;user space
	size	BM_SIZE	;4 before end of component

.imacro	bitmap	;code,x,y,width,height,{size},{u1,u2,u3,u4,u5,u6,...}
	;bitmap header template
 .check	%N>=6
%Ld:
	dc.i	%Le-%Ld
	dc.i	%1	;header control code
	dc.i	0	;BM_PARENT
	dc.i	%2	;BM_X
	dc.i	%3	;BM_Y
	dc.i	0	;BM_Z
	dc.i	%4	;BM_WIDTH
	dc.i	%5	;BM_HEIGHT
	dc.i	0	;BM_DEPTH
	dc.i	0	;BM_CLIPX
	dc.i	0	;BM_CLIPY
	dc.i	0	;BM_CLIPZ
	dc.i	%4	;BM_CLIPX1
	dc.i	%5	;BM_CLIPY1
	dc.i	0	;BM_CLIPZ1
	dc.i	NULL	;BM_XOFFSET
	dc.i	NULL	;BM_YOFFSET
	dc.i	NULL	;BM_ZOFFSET
	dc.i	NULL	;BM_CURSORX
	dc.i	NULL	;BM_CURSORY
	dc.i	NULL	;BM_CURSORZ
	dc.i	%2	;BM_NEWX
	dc.i	%3	;BM_NEWY
	dc.i	0	;BM_NEWZ
	dc.i	%4	;BM_NEWWIDTH
	dc.i	%5	;BM_NEWHEIGHT
	dc.i	0	;BM_NEWDEPTH
	dc.i	NULL	;BM_BITMAP (NULL=global bitmap)
	dc.i	NULL	;BM_BITSIZE
	dc.i	0,0,0	;hot patch list header
	dc.i	0,0,0	;trigger patch list header
	dc.i	WHITE	;BM_INK
	dc.i	BLACK	;BM_PAPER
	dc.i	NULL,NULL,NULL,NULL	;BM_TSTATE
	dc.i	NULL	;BM_FONT
	dc.i	-1	;BM_CLUT
	dc.i	NULL	;BM_CLUTPEN
	dc.i	256	;BM_CLUTLEN
	dc.i	NULL	;BM_CONTROL
 .if %N=6
	blk.b %6,0
 .elseif %N>6
 .rept %N-5
	dc.i	%6	;BM_USER?
 .mshift
 .endr
 .endif
	dc.i	%Le-%Ld
%Le:
.endm

;Gob node header structure

	structure
	struct	GB_NODE,ND_SIZE	;object node
	struct	GB_EXT,CP_SIZE	;component node
	pointer	GB_PARENT	;parent bitmap pointer (0=none)
	int32	GB_X	;x
	int32	GB_Y	;y
	int32	GB_Z	;z
	int32	GB_WIDTH	;width in pixels
	int32	GB_HEIGHT	;height in pixels
	int32	GB_DEPTH	;depth in pixels
	int32	GB_USER1	;user space1
	int32	GB_USER2	;user space2
	int32	GB_USER3	;user space3
	int32	GB_USER4	;user space4
	size	GB_SIZE	;4 before end of component

.imacro	gob	;code,width,height,parent,{size},{u1,u2,u3,u4,u5,u6,...}
	;graphic header template
 .check	%N>=5
%La:
	dc.i	%Lb-%La
	dc.i	%1	;header control code
	dc.i	%4	;GB_PARENT
	dc.i	NULL	;GB_X
	dc.i	NULL	;GB_Y
	dc.i	NULL	;GB_Z
	dc.i	%2	;GB_WIDTH
	dc.i	%3	;GB_HEIGHT
	dc.i	0	;GB_DEPTH
 .if %N=5
	blk.b	%5,0
 .elseif %N>5
 .rept %N-4
	dc.i	%5	;GB_USER?
 .mshift
 .endr
 .endif
	dc.i	%Lb-%La
%Lb:
.endm

;Sublist component structure

	structure
	struct	SL_NODE,CP_SIZE	;component node
	pointer	SL_HEAD	;list header pointer

.imacro	sublist	;code
	;sublist component template
 .check	%N=1
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	%1	;code vector
	dc.i	NULL	;SL_HEAD
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

;Embeded listhead component structure

	structure
	struct	EH_NODE,CP_SIZE	;component node
	struct	EH_LIST,LH_SIZE	;list header

.imacro	embedlist	;code
	;embeded listheader component template
 .check	%N=1
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	%1	;code vector
	dc.i	0,0,0	;EL_LIST
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

;Velocity component

	structure
	struct	MV_NODE,CP_SIZE	;component node
	int32	MV_XVEL	;x velocity
	int32	MV_YVEL	;y velocity
	int32	MV_XACC	;x acceleration
	int32	MV_YACC	;y acceleration
	int32	MV_MAXPX	;maximum positive x velocity
	int32	MV_MAXNX	;maximum negative x velocity
	int32	MV_MAXPY	;maximum positive y velocity
	int32	MV_MAXNY	;maximum negative y velocity

.imacro	vectors	;code,xv,yv,xacc,yacc,maxxv,maxyv
	;vector component template
 .check	%N=7
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	%1	;code vector
	dc.i	%2	;x velocity
	dc.i	%3	;y velocity
	dc.i	%4	;x accel
	dc.i	%5	;y accel
	dc.i	%6	;max pos x vel
	dc.i	-%6	;max neg x vel
	dc.i	%7	;max pos y vel
	dc.i	-%7	;max neg y vel
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

*Message data area structures

	structure	;mouse message
	pointer	MO_INST	;window instance pointer
	int32	MO_RX	;window rel x
	int32	MO_RY	;window rel y
	int32	MO_BUTTON	;buttons
	size	MO_SIZE	;size

	structure	;keyboard message
	pointer	KB_INST	;keyboard instance pointer
	int32	KB_LENGTH	;key stream length
	size	KB_DATA	;keydata

	structure	;file read/write message
	int32	FL_OFFSET	;file offset
	int32	FL_LENGTH	;file length
	size	FL_NAME	;file path

*Other data structures

;Tao DECLARE standard flag types

	structure
	byte	DINT64	;an int64 declare
	byte	DINT32	;an int32 declare
	byte	DDOUBLE	;an float64 declare
	byte	DFLOAT	;an float32 declare
	byte	DSTRING	;an string declare

*File Server object functions

	structure
	byte	SV_INFO
	byte	SV_READ
	byte	SV_WRITE
	byte	SV_CREATE
	byte	SV_DELETE
	byte	SV_RENAME
	byte	SV_DIR
	byte	SV_TIME
	byte	SV_TEMP
	byte	SV_MREAD
	byte	SV_SYNC
	byte	SV_TRUENAME
	byte	SV_SETATTR
	byte	SV_EXIT

*Device object functions

	structure
	byte	DV_QUIT
	byte	DV_INFO
	byte	DV_READ
	byte	DV_WRITE
	byte	DV_OPEN
	byte	DV_CLOSE
	byte	DV_PRIVATE
	byte	DV_STATUS

*Group object functions

	structure
	byte GR_QUIT
	byte GR_INFO
	byte GR_LOGIN
	byte GR_LOGOUT
	byte GR_SENDR
	byte GR_SEND

*24BIT device functions

	structure
	byte	LOAD24
	byte	CLS24
	byte	BLIT24

*GUI functions

	structure
	byte	OPENMENU	;open menu
	byte	OPENBROWSE	;open browser
	byte	OPENSTRING	;open string

;STREAMTP data packet structure

	structure
	int32	IN_STREAM	;stream number
	int32	IN_SEQNUM	;sequence number
	int32	IN_LENGTH	;data length (bytes,0=EOI,-1=TRIGGER)
	size	IN_DATA	;start of input data

;Pipe element structure

	structure	;pipe structure (returned by LRUN_PIPE)
	struct	EL_NODE,MN_SIZE	;object node
	int32	EL_COUNT	;number of pipe elements
	size	EL_IDS	;start of (64bit) id's

;Patch structure

	structure
	struct	PH_NODE,MN_SIZE	;memory node
	int32	PH_X	;patch x
	int32	PH_Y	;patch y
	int32	PH_X1	;patch x1 (x+xw)
	int32	PH_Y1	;patch y1 (y+yh)
	int32	PH_ID	;patch ID
	size	PH_SIZE	;size

;Topology table entry equates

	structure
	int32	TP_SERIAL
	int32	TP_ENTRIES
	size	TP_HSIZE

	structure
	int32	TP_PROCNUM	;allways chip number
	int32	TP_TYPE		;-1 if blank
	int32	TP_MEMORY	;-1 if blank
	int32	TP_HOPS		;MAXINT if blank
	size	TP_ESIZE

*Oops call equates and macros

;Oops 'instance' structure

	structure
	struct	OO_NODE,MN_SIZE	;link node+size
	int32	OO_CLASS	;ptr to class (CLASSTP object 2nd component)
	size	OO_DATA	;rest of data

;OO window* methods

	structure
	byte	WN_CLOSE
	byte	WN_FBOX
	byte	WN_UPDATE
	byte	WN_BORDER
	byte	WN_PRINT
	byte	WN_FUPDATE
	byte	WN_TBUTTON
	byte	WN_BUTTON
	byte	WN_CLPCLR
	byte	WN_BLIT
	byte	WN_BLITNIB
	byte	WN_BLITX2
	byte	WN_BOX
	byte	WN_CIRCLE
	byte	WN_GET
	byte	WN_HLINE
	byte	WN_LINE
	byte	WN_PLOT
	byte	WN_VLINE
	byte	WN_XBOX
	byte	WN_SCRLUP
	byte	WN_TTY
	byte	WN_INFO
	byte	WN_GETCLIP
	byte	WN_SETCLIP
	byte	WN_SETCUR
	byte	WN_GETCUR
	byte	WN_CLRPATCH
	byte	WN_ADDHOT
	byte	WN_ADDTRIG
	byte	WN_SETATTR
	byte	WN_GETATTR
	byte	WN_SETPAL
	byte	WN_GETPAL
	byte	WN_RESIZE
	byte	WN_NINFO
	byte	WN_REOPEN
	byte	WN_FPOLY
	byte	WN_DPOLY
	byte	WN_ADDGOB
	byte	WN_CLRGOB
	byte	WN_HITGOB
	byte	WN_NXTGOB
	byte	WN_TOFRONT
	byte	WN_TOBACK
	byte	WN_MTBUTTON
	byte	WN_MBUTTON
	byte	WN_SETVAR
	byte	WN_GETVAR

;OO file* methods

	structure
	byte	FP_CLOSE
	byte	FP_BGET
	byte	FP_BPUT
	byte	FP_SEEK
	byte	FP_FLUSH
	byte	FP_TELL

*remote/global window object structures

	structure
	struct	RW_NODE,OO_DATA	;'oops' header
	int64	RW_ID	;remote control mailbox ID
	int32	RW_SEQNUM	;remote sequence number
	size	RW_SIZE

	structure
	struct	GW_NODE,OO_DATA	;'oops' header
	int64	GW_ID	;remote control mailbox ID
	int32	GW_SEQNUM	;remote sequence number
	int32	GW_ROOTFLAG	;root process flag
	struct	GW_SLAVELIST,LH_SIZE	;slave mailbox list
	size	GW_SIZE

	structure
	struct	GWS_NODE,MN_SIZE
	int32	GWS_SEQNUM	;slave sequence number
	struct	GWS_MAILBOX,MB_SIZE	;slave mailbox
	size	GWS_SIZE

*Fixed colour equates

	structure
	byte	TRANS
	byte	BLACK
	byte	WHITE
	byte	RED
	byte	GREEN
	byte	BLUE
	byte	YELLOW
	byte	MAGENTA
	byte	CYAN
	byte	GREY
	byte	DRED
	byte	DGREEN
	byte	DBLUE
	byte	DYELLOW
	byte	DMAGENTA
	byte	DCYAN

	byte	GREY0
	byte	GREY1
	byte	GREY2
	byte	GREY3
	byte	GREY4
	byte	GREY5
	byte	GREY6
	byte	GREY7
	byte	GREY8
	byte	GREY9
	byte	GREY10
	byte	GREY11
	byte	GREY12
	byte	GREY13
	byte	GREY14
	byte	GREY15

RGBBLACK=$000000
RGBWHITE=$ffffff
RGBRED=$ff0000
RGBGREEN=$00ff00
RGBBLUE=$0000ff
RGBYELLOW=$ffff00
RGBMAGENTA=$ff00ff
RGBCYAN=$00ffff

*Taos OS vectors structure

	structure
	byte	VCALL
	byte	VADDR
	byte	FREEMEM
	byte	SUSPEND
	byte	ALLOCMEM
	byte	ADDNODE
	byte	ADDHEAD
	byte	ADDTAIL
	byte	REMOVENODE
	byte	COPYNODE
	byte	COPYHEAD
	byte	COPYTAIL
	byte	OBJPROC
	byte	REROUTE
	byte	DUMPLIST
	byte	UNBIND
	byte	SYSVARADDR
	byte	CLOSETOOL
	byte	SWITCHHI
	byte	SWITCHLO
	byte	SENDMAIL
	byte	COPYMAIL
	byte	READMAIL
	byte	DECLARE
	byte	GETMYID
	byte	GETDATA
	byte	ENQUIRE
	byte	OPENTOOL
	byte	PUTDATA
	byte	FLUSHTOOLS
	byte	WRITEDATA
	byte	LCALL
	byte	GETTIME
	byte	DELAY
	byte	DESCHEDULE
	byte	STARTCONTROL
	byte	ALLOCFAST
	byte	GETSERVER
	byte	DUMPVARS
	byte	STRINGCMP
	byte	RESUME
	byte	READDATA
	byte	FLUSHDATA
	byte	NETINFO
	byte	VCALLC
	byte	UNDECLARE

	byte	TAO_SWITCHHI
	byte	TAO_SWITCHLO
	byte	TAO_SWITCHTO

	byte	TAO_DECLARE
	byte	TAO_REDECLARE
	byte	TAO_UNDECLARE
	byte	TAO_ENQUIRE
	byte	TAO_VASEARCH
	byte	TAO_RDECLARE
	byte	TAO_RUNDECLARE
	byte	TAO_RREDECLARE

	byte	TAO_PUTDATA
	byte	TAO_GETDATA
	byte	TAO_READDATA
	byte	TAO_WRITEDATA

	byte	TAO_ALLOCMEM
	byte	TAO_FREEMEM
	byte	TAO_TESTMEM
	byte	TAO_LOCKMEM
	byte	TAO_UNLOCKMEM

	byte	TAO_ADDNODE
	byte	TAO_ADDHEAD
	byte	TAO_ADDTAIL
	byte	TAO_COPYNODE
	byte	TAO_COPYHEAD
	byte	TAO_COPYTAIL

	byte	TAO_SENDMAIL
	byte	TAO_SENDPART
	byte	TAO_COPYMAIL
	byte	TAO_READMAIL
	byte	TAO_READTYPE

	byte	TAO_LISTTEST
	byte	TAO_DUMPLIST
	byte	TAO_STRIPLIST
	byte	TAO_FREELIST
	byte	TAO_PRUNELIST
	byte	TAO_OBJPROC
	byte	TAO_LISTPROC

	byte	TAO_OPENCONTROL
	byte	TAO_OPENCHILD
	byte	TAO_OPENREMOTE
	byte	TAO_OPENDEVICE
	byte	TAO_OPENARRAY
	byte	TAO_OPENFARM
	byte	TAO_OPENGLOBAL
	byte	TAO_OPENPIPE

	byte	TAO_UNCLOSETOOL
	byte	TAO_CLOSETOOL

	byte	TAO_FINDTYPE
	byte	TAO_STRINGHASH
	byte	TAO_VERSION
	byte	TAO_FLUSHNAMES
	byte	TAO_ALLOCID
	byte	TAO_ADDPROC
	byte	TAO_REROUTE

	byte	TAO_STRINGLEN
	byte	TAO_STRINGCMP

	byte	TAO_SETINT
	byte	TAO_UNSETINT
	byte	TAO_WAITINT

*System variable numbers

	structure
	byte	VAR_SERVERID	;boot server id
	byte	VAR_LOCALSCREEN	;local screen object pointer
	byte	VAR_CTCOUNT	;control object count
	byte	VAR_MEMFREE	;pointer memfree ammount
	byte	VAR_LHINLINKS	;in link device list header
	byte	VAR_INPUTWIN	;current input window pointer
	byte	VAR_LHBITMAPS	;bitmaps list header
	byte	VAR_TOPOLOGY	;topology table pointer
	byte	VAR_MEMLIST	;pointer memfree list header
	byte	VAR_LHOFFCHIP	;offchip list header
	byte	VAR_LHLINKS	;out link device list header
	byte	VAR_PROCPOWER	;proc power
	byte	VAR_LHPETL	;local tool list header
	byte	VAR_PROCNUM	;proc number
	byte	VAR_VERSION	;version and registration number
	byte	VAR_ERRORDUMP	;error dump address pointer
	byte	VAR_LHFLUSH	;flush call back list header

;rooting stucture equates

	structure
	struct	RT_NODE,MN_SIZE	;link number node stuff
	struct	RT_ENTRY,LH_SIZE	;proc entry list header
	pointer	RT_LINK	;this rooting node link number
	pointer	RT_GUARD	;local guard table pointer
	size	RT_SIZE

	structure
	struct	ET_NODE,MN_SIZE	;entry node stuff
	int32	ET_PROCNUM	;processor number
	size	ET_SIZE

;data cache tag

	structure
	struct	DT_NODE,MN_SIZE	;data tag node
	int32	DT_BLOCK	;data block pointer
	int32	DT_SEQNUM	;sequence number
	int32	DT_TIME	;local time
	size	DT_SIZE	;size

;declared variable structure

	structure
	struct	VA_NODE,MN_SIZE	;link node
	int64	VA_VALUE	;variable value
	int32	VA_ATTR	;variable attr
	size	VA_NAME	;variable name

*Object template building macros

.imacro	tstring	;name,string	;define string
 .check	%N=2	;args
	even
%1:	dc.i	NULL,NULL
	dc	%2{1,99U},0
.endm

.imacro	componentsp	;tooloffset,size
	;tool data component template
 .check	%N=2
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	%1	;code vector
	blk.b	%2,0
	even
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

.imacro	component	;code OR nodelabel, toolstring
	;tool component template
 .check	%N=2|(%N=1)
%La:	dc.i	%Lb-%La	;offset to next component
 .if %N=2
	.eval SAVETEXTQ __tool_%1_q,0,%2{1,99U}
	dc.i	__tstr_%1_%e - %1
 .else
	dc.i	%1	;code vector
 .endif
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

.imacro	components	;clabel, code OR clabel, nodelabel, toolstring
	;tool data component template - first half
 .check	%N=2|(%N=3)
%1:	dc.i	%1e-%1	;offset to next component
 .if %N=3
	.eval SAVETEXTQ __tool_%2_q,0,%3
	dc.i	__tstr_%2_%e - %2
 .else
	dc.i	%2
 .endif
.endm

.imacro	componente	 ;clabel
	;last half of component
	dc.i	%1e-%1	;offset to last component
 %1e:
.endm

.imacro	controlend
 .check	%N=1
	;components end marker
	dc.i	NULL	;end of components marker
 .if 0<>GETNUMQ __tool_%1_q
 .rept GETNUMQ __tool_%1_q
	.eval (GETNUMQ __tool_%1_q)-%x
	.GETTEXTQ __tool_%1_q,%e
	.align
__tstr_%1_%e:
	dc.i	NULL,NULL
	dc	%T,0
 .endr
 .endif
.endm

.imacro	compspace	;label,size
	;tool data component template
 .check	%N=2
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	NULL	;code vector
%1:
	blk.b	%2,0
	even
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

.imacro	compstring	;code offset,string
	;tool data component template
 .check	%N=2
%La:	dc.i	%Lb-%La	;offset to next component
	dc.i	%1	;code vector
	dc.b	%2,0
	even
	dc.i	%Lb-%La	;offset to last component
%Lb:
.endm

.endif
