.if ~?def(DEF_TAO_SYS)
DEF_TAO_SYS=TRUE

;debug macros

.imacro	TRACEF		;fmt,arg1 ... argn
	pshm	r0,r3,r15
__bytes_pushed:=0
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r0
	cpy	r7,r3
	qcall LIB/TRACEF,VIRTUAL+FIXUP
	.if __bytes_pushed<>0
		add __bytes_pushed,r7    	;remove params from stack
	.endif
	popm	r15,r3,r0
.endm

.imacro	ERRORF	;fmt,arg1 ... argn
	pshm	r0,r3,r15
__bytes_pushed:=0
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval	__tool_num+SAVETEXTQ __string_q,0,{%1}
	lea __string_%e,r0
	cpy r7,r3
	qcall	LIB/ERRORF,VIRTUAL+FIXUP
	.if __bytes_pushed<>0
		add __bytes_pushed,r7    	;remove params from stack
	.endif
	popm	r15,r3,r0
.endm

;
; AS 29/7/93
; setup for DEBUGF
; r0=pointer to stack containing r0,r8,r15
; r8=linenumber; ( qcall trashes r15 )
.imacro	dbg
 .check	%N<=1	;optional line number
;
; r0 is trashed by pointing to stack,r8 used to pass line number
; r15 is trashed by the qcall itself
; debugf saves all register values
	pshm	r0,r8,r15	;save regs trashed by call
 .if %N=0
	cpy	-1,r8	;show not valid line number
 .else
	cpy	%1,r8	;line number
 .endif
	cpy	r7,r0	;point to regs
	qcall LIB/DEBUGF,VIRTUAL+FIXUP
	popm	r15,r8,r0	;restore used regs
.endm

;
; macros which are to be ignored by the assembler,
; but which are to be picked up by a stdio tool which adds
; the dbg macro after each source line
.imacro	dbgon
.endm

.imacro	dbgoff
.endm

.imacro	dbg_on		;alternate syntax
.endm

.imacro	dbg_off
.endm

;New,ARH 19.feb.92:
;8.dec.93: fixed string

.imacro	TRACEDUMP	;str,dumpaddress,size,str2
	pshm	r0,r2,r3,r8,r10,r15
	allocstruct	4,r7
	cpy	%3,r10
	cpy	%2,r2
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r0
	qcall LIB/TRACEF,VIRTUAL+FIXUP	;str
%Loop:	cpy.b	[r2],r8
	cpy	r8,[r7]
	.eval __tool_num+SAVETEXTQ __string_q,0,{'\n%%02X '}
	lea	__string_%e,r0
	cpy	r2,r8
	and	7,r8	;tables of 8
	tst	r8
	beq	%Lp2
	inc	r0	;skip LF normally
%Lp2:	cpy	r7,r3
	qcall LIB/TRACEF,VIRTUAL+FIXUP	;00
	inc	r2
	dec	r10
	tst	r10
	bne	%Loop
	.eval __tool_num+SAVETEXTQ __string_q,0,{%4}
	lea	__string_%e,r0
	qcall LIB/TRACEF,VIRTUAL+FIXUP	;str2
	freestruct	4
	popm	r15,r10,r8,r3,r2,r0
.endm

.imacro tracef_regs
 .check %N=0 ;no params required to tracef_regs
	pshm r15,r14,r13,r12,r11,r10,r9,r8,r7,r6,r5,r4,r3,r2,r1,r0
	cpy r7,r1
	tracef "VP registers\n"
	clr r8
	cpy 8,r9
	forsp 8
		tracef "r%-1d/r%-6d",r8,r9
		inc r8
		inc r9
	nextsp
	tracef "\n"
	forsp 8
		tracef "$%-8x ",[r1]
		add 4,r1
	nextsp
	tracef "\n"
	forsp 8
		tracef "$%-8x ",[r1]
		add 4,r1
	nextsp
	tracef "\n\n"
	popm r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15
.endm

.imacro tracef_stack
 .check %N=1 ;how many words to display to tracef_stack
 .check ~?reg(%1) ;constant expected to tracef_stack
 .check %1>0
	pshm r1,r8
	tracef "Stack\n"
	cpy r7,r1
	add 8,r1
	cpy (%1*4)-4,r8   ;count from n-1 to zero inclusive
	repeat
		tracef "[r7+%-2d] = $%x\n",r8,[r1+r8]
		sub 4,r8
	until r8<0        ;display offset zero
	tracef "\n"
	popm r8,r1
.endm

.imacro	PRINTF		;fmt,arg1 ... argn
__bytes_pushed:=0
	psh	r3
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r0
	cpy	r7,r3
	qcall LIB/PRINTF
	.if __bytes_pushed<>0
		add __bytes_pushed,r7    	;remove params from stack
	.endif
	pop	r3
.endm

.imacro	PRINTFP		;fmtptr,arg1 ... argn
__bytes_pushed:=0
	psh	r3
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	copy	%1,r0
	cpy	r7,r3
	qcall LIB/PRINTF
	.if __bytes_pushed<>0
		add __bytes_pushed,r7    	;remove params from stack
	.endif
	pop	r3
.endm

.imacro	SCANF		;fmt,arg1 ... argn
__bytes_pushed:=0
	psh	r3
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r0
	cpy	r7,r3
	qcall LIB/SCANF
	.if __bytes_pushed<>0
		add __bytes_pushed,r7    	;remove params from stack
	.endif
	pop	r3
.endm

.imacro psh_param ;N,... ; push on backwards
 .if (%1) > 1
	psh_param (%1)-1,%3,%4,%5,%6,%7,%8,%9
 .endif
 .if (%1) > 0
 .ifnb %2{&'.D'|'.d'|'.L'|'.l',2}
	psh.l %2{1,'.D'|'.d'|'.L'|'.l'} ;push it if double/long
__bytes_pushed:=__bytes_pushed+8
 .else
 .ifnb %2{&'.F'|'.f',2}
	psh.l r14
	cpy.f %2{1,'.F'|'.f'},r14
	f2d r14
	exg.l r14,[r7]
__bytes_pushed:=__bytes_pushed+8
 .else
	psh.i %2{1,'.I'|'.i'} ;push it if float or int
__bytes_pushed:=__bytes_pushed+4
 .endif
 .endif
 .endif
.endm

;register read/write supressor macro

.imacro	copy	;source,dest
 .check	%N=2
 .if ?REG(%1) & ?REG(%2)		;both registers
 .if (%1)<>(%2)
	cpy	%1,%2
 .endif
 .else
	cpy	%1,%2
 .endif
.endm

;list macros

.imacro	initlist	;header
	;list header initialisation
	;inputs
	;header
 .check	%N=1
	cpy	%1,[%1+0]		;list head points to list head
	cpy	%1,[%1+LH_TAILPRED]	;list tailpred points to list head
	add	LH_TAIL,[%1+0]	;list head points to list tail
	clr	[%1+LH_TAIL]		;clear list header tail
.endm

.imacro	succ	;node,next
	;get succesor
 .check	%N=2
	cpy	[%1+LN_SUCC],%2	;points to next node
.endm

.imacro	pred	;node,last
	;get predesesor
 .check	%N=2
	cpy	[%1+LN_PRED],%2	;points to last node
.endm

.imacro	succnode	;lookahead,node,label
	;succnode
 .check	%N=3
	copy	%1,%2		;get lookahead pointer
	cpy	[%1+LN_SUCC],%1	;points to next node
	tst	%1
	beq	%3		;branch if on tail
.endm

.imacro	prednode	;lookahead,node,label
	;prednode
 .check	%N=3
	copy	%1,%2		;get lookahead pointer
	cpy	[%1+LN_PRED],%1	;points to next node
	tst	%1
	beq	%3		;branch if on tail
.endm

.imacro	addnode	;node,nnode,temp
	;add new node at node
 .check	%N=3
	cpy	[%1+LN_SUCC],%3	;save pointer to next node
	cpy	%3,[%2+LN_SUCC]	;new node points forward to next
	cpy	%2,[%1+LN_SUCC]	;node points forward to new node
	cpy	%1,[%2+LN_PRED]	;new node points back to node
	cpy	%2,[%3+LN_PRED]	;next node points to new node
.endm

.imacro	addhead	;head,node,temp
	;add node to head
 .check	%N=3
	cpy	[%1+LH_HEAD],%3	;save pointer to old first node
	cpy	%2,[%1+LH_HEAD]	;list head points forward to new first node
	cpy	%3,[%2+LN_SUCC]	;new first node points forward to old first node
	cpy	%1,[%2+LN_PRED]	;new first node points back to list head
	cpy	%2,[%3+LN_PRED]	;old first node points back to new first node
.endm

.imacro	addtail	;head,node,temp
	;add node to tail
 .check	%N=3
	cpy	[%1+LH_TAILPRED],%3	;save pointer to old last node
	cpy	%2,[%1+LH_TAILPRED]	;list header points back to new last node
	cpy	%1,[%2+LN_SUCC]
	add	LH_TAIL,[%2+LN_SUCC]	;new last node points forward to list tail
	cpy	%3,[%2+LN_PRED]	;new last node points back to old last node
	cpy	%2,[%3+LN_SUCC]	;old last node points forward to new last node
.endm

.imacro	remhead	;head,node,temp2,label
	;remove head node
 .check	%N=4
	cpy	[%1+LH_HEAD],%2	;get pointer to first node
	tst	[%2+LN_SUCC]
	beq	%4		;branch if empty
	succ	%2,%3		;get forward pointer to next node
	cpy	%3,[%1+LH_HEAD]	;set head to point to new first node
	cpy	%1,[%3+LN_PRED]	;set new first node to point to head
.endm

.imacro	remove	;node,temp
	;remove node
 .check	%N=2
	cpy	[%1+LN_SUCC],%2
	cpy	[%1+LN_PRED],%1
	cpy	%2,[%1+LN_SUCC]
	cpy	%1,[%2+LN_PRED]
.endm

;language macros

.imacro	killobject	;object
	;kill object pointed to
	;inputs
	;object pointer
 .check	%N=1
	cpy	-1,[%1+ND_NUMBER]
.endm

.imacro	allocstruct	;size,reg
	;allocate structure on stack
	;inputs
	;size (in bytes)
	;register
	;outputs
	;register=structure pointer
 .check	%N=2
	sub	%1,r7
	copy	r7,%2
.endm

.imacro	freestruct	;size
	;free struct on stack
	;inputs
	;size (in bytes)
	;outputs
	;r7=r7 before allocstruct
 .check	%N=1
 .if ?reg	(%1)
	add	%1,r7
 .else
	lea	[r7+(%1)],r7
 .endif
.endm

.imacro initmbox	;register,filter
	;Initialise mailbox structure pointed to by %1
	;Inputs
	; %1=register pointing to structure
	; %2=filter word
 .check %N=2				;initmbox takes 2 parameters
	initlist %1				;initialise maillist
	clr [%1+MB_STATE]		;clear state
	cpy %2,[%1+MB_FILTER]	;set filter
	cpy 12345678,[%1+MB_MAGIC]	;validate it
.endm

.imacro	allocmbox	;register,filter
	;allocate temp mailbox structure on stack
	;inputs
	;structure register
	;filter word
 .check	%N=2
	allocstruct	MB_SIZE,r7		;temporary mailbox
	initmbox r7,%2
	copy r7,%1
.endm

.imacro	freembox
	;free temp mailbox on stack
	;inputs
	;r7=r7 before allocmbox
	clr	[r7+MB_MAGIC]	;clear magic
	lea	[r7+MB_SIZE],r7
.endm

;Taos call Macros

.imacro	vaddr	;object,item
	;inputs
	;containing object
	;embeded object number
	;outputs
	;r0=NULL if error
	;r0=pointer to embeded object
 .check	%N=2
	copy	%1,r0
	copy	%2,r15
	tao	VADDR
.endm

.imacro	freemem	;start,size
	;free memory block
	;inputs
	;start of block (word aligned)
	;size of block (in bytes,word aligned)
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	FREEMEM
.endm

.imacro	freenode	;start
	;free node
	;inputs
	;start of node (word aligned)
 .check	%N=1
	copy	%1,r0
	cpy	[r0+MN_BYTES],r8
	tao	FREEMEM
.endm

.imacro	allocmem	;size
	;allocate memory block
	;inputs
	;size of block (in bytes,word aligned)
	;outputs
	;r8=0 if error
	;r0=start of block
	;r8=size of block given (in bytes)
 .check	%N=1
	copy	%1,r8
	tao	ALLOCMEM
.endm

.imacro	copynode	;node
	;copy node
	;inputs
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=1
	copy	%1,r0
	tao	COPYNODE
.endm

.imacro	copyhead	;list,node
	;copy node onto head of list
	;inputs
	;list pointer
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=2
 .if %2=r0
	copy	%2,r1
	copy	%1,r0
 .else
	copy	%1,r0
	copy	%2,r1
 .endif
	tao	COPYHEAD
.endm

.imacro	copytail	;list,node
	;copy node onto tail of list
	;inputs
	;list pointer
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=2
	copy	%1,r0
	copy	%2,r1
	tao	COPYTAIL
.endm

.imacro	removenode	;node
	;copy node
	;inputs
	;node pointer
 .check	%N=1
	copy	%1,r0
	tao	REMOVENODE
.endm

.imacro	objproc	;object
	;process an object
	;inputs
	;object pointer
 .check	%N=1
	copy	%1,r0
	tao	OBJPROC
.endm

.imacro	listproc	;list
	;process an object list
	;inputs
	;list pointer
 .check	%N=1
	copy	%1,r0
	tao	LISTPROC
.endm

.imacro	dumplist	;list
	;free a node list
	;inputs
	;list pointer
 .check	%N=1
	copy	%1,r0
	tao	DUMPLIST
.endm

.imacro	striplist	;list,type/s
	;strip a node list
	;inputs
	;list pointer
	;type mask
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	STRIPLIST
.endm

.imacro	freelist	;list
	;free an object list
	;inputs
	;list pointer
 .check	%N=1
	copy	%1,r0
	tao	FREELIST
.endm

.imacro	prunelist	;list,type/s
	;prune a object list
	;inputs
	;list pointer
	;type mask
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	PRUNELIST
.endm

.imacro	listtest	;list,types
	;test list
	;inputs
	;list pointer
	;type/s mask
	;outputs
	;r8=0 if no messages of your type
	;r8=message type
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	LISTTEST
.endm

.imacro	testmymail	;types
	;test list
	;inputs
	;type/s mask
	;outputs
	;r8=0 if no messages of your type
	;r8=message type
 .check	%N=1
	lea	[r6+CT_MAILBOX],r0
	cpy	%1,r8
	tao	LISTTEST
.endm

.imacro	sendmail	;message
	;send message
	;inputs
	;message pointer
 .check	%N=1
	copy	%1,r0
	tao	SENDMAIL
.endm

.imacro	sendhead	;message
	;send message head
	;inputs
	;message pointer
 .check	%N=1
	copy %1,r0
	cpy	[r0+MG_OFFSET],r8
	tao	SENDPART
.endm

.imacro	sendpart	;message
	;send part of message
	;inputs
	;message pointer
	;section size in bytes
 .check	%N=2
	copy %1,r0
	copy %2,r8
	tao	SENDPART
.endm

.imacro	copymail	;message
	;copy message and send
	;inputs
	;message pointer
	;outputs
	;r8=0 if error
 .check	%N=1
	copy	%1,r0
	tao	COPYMAIL
.endm

.imacro	readmail	;mailbox,types
	;readmail from mailbox
	;inputs
	;mailbox pointer
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	READMAIL
.endm

.imacro	readmymail	;types
	;readmail from my mailbox
	;inputs
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
 .check	%N=1
	lea	[r6+CT_MAILBOX],r0
	copy	%1,r8
	tao	READMAIL
.endm

.imacro	readtype	;mailbox,types
	;readtype from mailbox
	;inputs
	;mailbox pointer
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
 .check	%N=2
	copy	%1,r0
	copy	%2,r8
	tao	READTYPE
.endm

.imacro	declare	;name,mailidl,mailidh
	;declare a 64 bit variable
	;inputs
	;r6=control object pointer
	;name string
	;mailbox id low
	;mailbox id high
	;outputs
	;r8=0 if error
 .check	%N=3
	copy	%2,r8
	copy	%3,r9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	copy	DINT64,r10
	tao	DECLARE
.endm

.imacro	undeclare	;name
	;undeclare a 64 bit variable
	;inputs
	;r6=control object pointer
	;name string
	;outputs
	;r8=0 if error
 .check	%N=1
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	tao	UNDECLARE
.endm

.imacro	enquire	;name,level
	;find a 64 bit variable value
	;inputs
	;r6=control object pointer
	;name string
	;enquire level
	;outputs
	;r8=0 if error
	;r9+r10=64 bit value
 .check	%N=2
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	copy	%2,r8
	tao	ENQUIRE
.endm

.imacro	getserver	;parent,filename
	;split an accsess route
	;inputs
	;parent object
	;filename pointer
	;outputs
	;r1=local name string pointer
	;r9,r10=SERVER ID
 .check	%N=2
	copy	%1,r0
	copy	%2,r1
	tao	GETSERVER
.endm

.imacro	opentool	;filename,idlow,idhigh
	;open a tool
	;inputs
	;filename pointer
	;server low ID
	;server high ID
	;outputs
	;r8=0 if error
	;r0=installed tool pointer
	;r1=tool code pointer
 .check	%N=3
	copy	%1,r1
	copy	%2,r9
	copy	%3,r10
	tao	OPENTOOL
.endm

.imacro	closetool	;tool
	;close a tool
	;inputs
	;tool object pointer
 .check	%N=1
	copy	%1,r0
	tao	CLOSETOOL
.endm

.imacro	flushtools
	;flush tools on tools list
	tao	FLUSHTOOLS
.endm

.imacro	gettime
	;get local time (in 64 us units)
	;outputs
	;r8=time
	tao	GETTIME
.endm

.imacro	delay	;time
	;deshedule process for time (in 64 uS units)
 .check	%N=1
	copy	%1,r8
	tao	DELAY
.endm

.imacro	deschedule
	;deshedule process for one control cycle
	tao	DESCHEDULE
.endm

.imacro	startcontrol	;control,mailidl,mailidh
	;start a control object
	;inputs
	;control object pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r0=control object pointer
 .check	%N=3
	copy	%1,r0
	copy	%2,r8
	copy	%3,r9
	tao	STARTCONTROL
.endm

.imacro	opencontrol	;control,mailidl,mailidh
	;create a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r0=new control object pointer
 .check	%N=3
	copy	%1,r0
	copy	%2,r8
	copy	%3,r9
	tao	OPENCONTROL
.endm

.imacro	openchild	;control,mailidl,mailidh
	;distribute and open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=3
	copy	%1,r0
	copy	%2,r8
	copy	%3,r9
	tao	OPENCHILD
.endm

.imacro	openremote	;control,mailidl,mailidh,procnum
	;remote open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;target proc number
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=4
	copy	%1,r0
	copy	%2,r8
	copy	%3,r9
	copy	%4,r10
	tao	OPENREMOTE
.endm

.imacro	opendevice	;control,mailidl,mailidh,procnum
	;target and open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;target proc number
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=4
	copy	%1,r0
	copy	%2,r8
	copy	%3,r9
	copy	%4,r10
	tao	OPENDEVICE
.endm

.imacro	openarray	;array1,array2,mailidl,mailidh,entries
	;open an array of child control objects
	;inputs
	;offset array pointer (32 bit)
	;target array pointer (64 bit)
	;parent mailbox id low int32
	;parent mailbox id high int32
	;entries
	;outputs
	;r8=0 if any child failed (0 in target array)
 .check	%N=5
	copy	%1,r0
	copy	%2,r1
	copy	%3,r8
	copy	%4,r9
	copy	%5,r10
	tao	OPENARRAY
.endm

.imacro	openfarm	;temp,array2,mailidl,mailidh,entries
	;open a farm of child control objects
	;inputs
	;child control object pointer
	;target array pointer (64 bit)
	;parent mailbox id low int32
	;parent mailbox id high int32
	;entries
	;outputs
	;r8=0 if any child failed (0 in target array)
 .check	%N=5
	copy	%1,r0
	copy	%2,r1
	copy	%3,r8
	copy	%4,r9
	copy	%5,r10
	tao	OPENFARM
.endm

.imacro	openglobal	;temp,array2,mailidl,mailidh,num,start
	;open a global farm of child control objects
	;inputs
	;child control object pointer
	;target array pointer (64 bit)
	;parent mailbox id low int32
	;parent mailbox id high int32
	;number of children
	;start chip number
	;outputs
	;r8=0 if any child failed (0 in target array)
 .check	%N=6
	copy	%1,r0
	copy	%2,r1
	copy	%3,r8
	copy	%4,r9
	copy	%5,r10
	copy	%6,r11
	tao	OPENGLOBAL
.endm

.imacro	findtype	;memory,startnum,type
	;find a target chip number
	;inputs
	;memory required (in bytes)
	;start proc number
	;type (0=VP)
	;outputs
	;r8=0 if error
	;r8=memory present
	;r9=proc number
	;r10=type found
 .check	%N=3
	copy	%1,r8
	copy	%2,r9
	copy	%3,r10
	tao	FINDTYPE
.endm

.imacro	getmyid	;control
	;get a 64 bit mailbox ID
	;inputs
	;control object pointer
	;outputs
	;r8+r9=64 bit value
 .check	%N=1
 .if %1=r6
	tao	GETMYID
 .else
	psh	r6
	copy	%1,r6
	tao	GETMYID
	pop	r6
 .endif
.endm

.imacro	getparent	;control
	;get a 64 bit mailbox ID
	;inputs
	;control object pointer
	;outputs
	;r8+r9=64 bit value of parent
 .check	%N=1
	cpy.l	[%1+CT_PARENT],r8
.endm

.imacro	random	;range
	;get random number
	;inputs
	;range
	;outputs
	;r15=random number in range
 .check	%N=1
	copy	%1,r14
	qcall LIB/Q_RANDOM
.endm

;vcall macros

.imacro	qcall ;unquoted-string or handle [,flags]
	.if %N=1
	QCL	SAVETEXTQ __qcall_q,0,%1{1,99U}
	.else
 .check	%N=2	;qcall: 1 or 2 parameters req'd
	QCL	SAVETEXTQ __qcall_q,(%2)&3,%1{1,99U}
	.endif
.endm

.imacro	scall	;unquoted-string or handle [,flags]
	.if %N=1
	SCL	SAVETEXTQ __qcall_q,0,%1{1,99U}
	.else
 .check	%N=2	;qcall: 1 or 2 parameters req'd
	SCL	SAVETEXTQ __qcall_q,(%2)&3,%1{1,99U}
	.endif
.endm

.imacro	vcall	;unquoted-string or handle [,flags]
	.if %N=1
	__tmp:=SAVETEXTQ __qcall_q,0,%1{1,99U}
	.else
 .check	%N=2	;vcall: 1 or 2 parameters req'd
	__tmp:=SAVETEXTQ __qcall_q,(%2)&3,%1{1,99U}
	.endif
	cpy	__tmp,r15
	tao	VCALL
.endm

.imacro	lcall	;reg,method-id
	copy	%1,r0
	copy	%2,r15
	tao	LCALL
.endm

.imacro gr_login	;name, reg1,reg2
	.check %N=3
	.check %3<>r8	;LS part of mailbox ID cannot be held in r8
	;Macro to log in a mailbox Id to a group device.
	;Inputs:
	; %1 = Group device name
	; %2 = Most significant part of mailbox ID to log in
	; %3 = Least significant part of mailbox ID to log in
	;Outputs:
	; r8 = -1 if error, else success

	copy %2,r8
	copy %3,r9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	qcall SERVER/GR_LOGIN
.endm

.imacro gr_logout	;name, reg1,reg2
	.check %N=3
	.check %3<>r8	;LS part of mailbox ID cannot be held in r8
	;Macro to log out a mailbox Id from a group device.
	;Inputs:
	; %1 = Group device name
	; %2 = Most significant part of mailbox ID to log out
	; %3 = Least significant part of mailbox ID to log out
	;Outputs:
	; r8 = -1 if error, else success

	copy %2,r8
	copy %3,r9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	qcall SERVER/GR_LOGOUT
.endm

.imacro gr_sendr	;name, pointer to message, exc1, exc2
	.check %N=4
	.check %4<>r9
	;Macro to send a message to all members of a group device, and wait
	; for reply.
	;Inputs:
	; %1 = Group device name
	; %2 = Pointer to message to send
	; %3 = Low part of mailbox ID to exclude from group send (or 0)
	; %4 = High part of mailbox ID to exclude from group send (or 0)
	;Outputs:
	; r8 = -1 if error, else success

	copy %3,r9
	copy %4,r10
	copy %2,r0
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	qcall SERVER/GR_SENDR
.endm

.imacro gr_send	;name, pointer to message, exc1, exc2
	.check %N=4
	.check %4<>r9
	;Macro to send a message to all members of a group device. Does not
	; wait for a reply.
	;Inputs:
	; %1 = Group device name
	; %2 = Pointer to message to send
	; %3 = Low part of mailbox ID to exclude from group send (or 0)
	; %4 = High part of mailbox ID to exclude from group send (or 0)
	;Outputs:
	; r8 = -1 if error, else success

	copy %3,r9
	copy %4,r10
	copy %2,r0
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	qcall SERVER/GR_SENDR
.endm

.imacro gr_quit	;name
	.check %N=1
	;Macro to send a quit message to a group device.
	; (THE QUIT MESSAGE DOES NOT GET SENT TO MEMBERS OF THE GROUP)
	;Inputs:
	; %1 = Group device name
	;Outputs:
	; r8 = -1 if error, else success

	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	lea	__string_%e,r1
	qcall SERVER/GR_QUIT
.endm

*For oops stuff

.imacro	construct	;size,errjmp
	copy %1,r8
	tao	ALLOCMEM
	tst	r8
	beq	%2
	cpy	r8,[r0+MN_BYTES]	;save size
	cpy	r0,r1
 .eval __tool_num
	lea __cd%e_r4,r0
	sub	[r0-12],r0
	sub	ND_SIZE+CP_SIZE,r0
	tao	UNCLOSETOOL		;increase tool references
 .eval __tool_num
	lea __cd%e_r4,r0
	sub CP_SIZE,r0
	add	[r0+CP_VEC],r0		;skip to next comp
	cpy	r0,[r1+OO_CLASS]	;save class ptr
	cpy	r1,r0
.endm

.endif
