;TBM structure include file. V1.0
;TBM (Taos BitMap) is the picture format used by the Taos GUI. The format was
;chosen to be flexible and cope with future standards as well as existing ones.
;It is based on the idea of chunks which have an ID, length and body. Chunks
;can contain other chunks and indeed the tbm chunks are themselves inside the
;TTBM chunk. Applications are free to add their own specific chunks to tbms
;they save without fear of breaking other applications as the rule when
; reading is "skip the chunks you can't understand". eg a fractal program
;could have a specific fractal chunk which contained the seed values for the
;picture in the tbm.
;Additional information can be found in the documentation for the tbm toolset.


.if ~?def(DEF_TB_EQU)
DEF_TB_EQU=TRUE


; Where a description says 'total size of xxx block' this can be read as
; 'number of bytes to add to start of a block to get to the next block'
	structure
	struct	TB_IDENT,4	;'TTBM' ident text
	int32	TB_SIZE	;total size of ttbm block
	int32	TB_DATA	;actual data starts here

	structure
	struct	TB_HDIDENT,4	;'BMHD' ident text
	int32	TB_HDSIZE	;total size of bmhd block
	int32	TB_WIDTH	;frame width (in pixels)
	int32	TB_HEIGHT	;frame height (in pixels)

;TB_FORMAT	mode	description
;	RAW.	raw bytes,can use blit to copy to screen
;*	NIBL	16 colour mode,colour values packed as nibbles
;	RGB8	8 bit RGB format ie redbyte,greenbyte,bluebyte etc
;*	RGB4	4 bit RGB format ie rednibble,greennib,bluenib etc
;*Note these formats are currently not fully implemented.


	int32	TB_FORMAT	;format of data 'RAW.','RGB8' etc

;TB_FDATA	mode	data
;	RAW.	none
;	NIBL	basecol
;	RGB8/RGB4	none

	int32	TB_FDATA	;data for above

	int32	TB_COMPRESS	;0 if none,RUNB=run byte (Not currently implemented.)

	structure
	struct	TB_CRIDENT,4	;'COLR' ident text
	int32	TB_CRSIZE	;total size of colour block
	int32	TB_NREGS	;number of colour regisers to load
	int32	TB_FRSTREG	;1st colour reg to load
	int32	TB_REGDATA	;3 bytes per entry of R,G,B.+pad bytes to word boundry

	structure
	struct	TB_BDIDENT,4	;BODY ident text
	int32	TB_BDSIZE	;total size of body block
	int32	TB_BODY	;body data

.endif

